﻿# ================================================================================================================
# Paket: Google Chrome
# Beschreibung: <Kurzbeschreibung des Pakets>
# Autor: admhaeringe
# Erstelldatum: 27.05.2025
# Revision: 3
# Letzte Änderung: 28.08.2025
# Historie: <Kurze Beschreibung der Änderungen>
# Abhängigkeiten: <Abhängige Pakete oder Systemkomponten>
# Besonderheiten: <Links, Blogs, KB-Artikel, etc.>
# ================================================================================================================
# ===== Installationsvariablen
Set-PdVar -Name _MSIName -Value '.\Files\googlechromestandaloneenterprise64.msi'
Set-PdVar -Name _ProcessNames -Value 'Msiexec.exe'
Set-PdVar -Name _ReturnCode -Value ''
# 
# === Laufende Prozesse, die in der Prozesslistenvariable definiert sind, beenden
if ($_ProcessNames -ne '')
{
    foreach ($_Process in ($_ProcessNames -split ",")) {Stop-PdProcess -Name $_Process -NameOf File -Select AllMatches -SupportUninstall -Context Computer -ContinueOnError}
}
# 
# ===== Installation
Install-MsiProduct -Path $_MSIName -InstallationMode Install -Target AllUsers -Options 'params:NOGOOGLEUPDATEPING=1' -LogLevel NORMAL -ResultVariable _ReturnCode -Context Computer
if (($_ReturnCode -ne 0) -and ($_ReturnCode -ne ''))
{
    if ($_ReturnCode -eq 1602)
    {
        Exit-Package -Status Failed -Message 'Das Setup hat den Rückgabewert 1602 zurückgegeben. Abbruch durch Benutzer.'
    }
    if ($_ReturnCode -eq 1618)
    {
        Exit-Package -Status Undone -Message 'Das Setup hat den Rückgabewert 1618 zurückgegeben. Eine andere MSI-Installation wird aktuell ausgeführt.'
    }
    if ($_ReturnCode -eq 1638)
    {
        Exit-Package -Status Failed -Message 'Das Setup hat den Rückgabewert 1638 zurückgegeben. Eine andere Version dieses Produkts ist bereits installiert.'
    }
    else
    {
        Exit-Package -Status Failed -Message "Abbruch. Die Ausführung wurde mit dem Rückgabewert ${_ReturnCode} beendet."
    }
}
# 
# ===== Config kopieren
if (Test-FileExists -Path "${env:ProgramFiles}\Google\Chrome\Application\master_preferences")
{
    Copy-File -File '.\Files\master_preferences' -TargetDir "${env:ProgramFiles}\Google\Chrome\Application" -Replace Always -Context Computer
}
# 
# ===== Desktopsymbol AllUsers löschen
Remove-Link -Description 'Google Chrome' -Folder 'Desktop\' -ComputerRelatedLink -Context Computer
# 
# ===== Deinstallation
# Die Befehle zwischen der Sprungmarke $BeginUninstallScript und dem Ende des Skripts werden (ausschließlich) bei der Deinstallation des Pakets ausgeführt.
# Fügen Sie hier Befehle hinzu, um Installationsbefehle rückgängig zu machen, für die eine automatische Deinstallation nicht möglich ist.
Set-Label -Name "`$BeginUninstallScript"
